# SPDX-FileCopyrightText: 2024-2025 Andrew Gunnerson
# SPDX-License-Identifier: GPL-3.0-only

source "${0%/*}/boot_common.sh" /data/local/tmp/msd/service.log

header Starting daemon

# Full path because Magisk runs this script in busybox's standalone ash mode and
# we need Android's toybox version of runcon.
/system/bin/runcon u:r:msd_daemon:s0 \
    "${mod_dir}"/msd-tool."$(getprop ro.product.cpu.abi)" \
        daemon --log-target logcat --log-level debug &

sleep 1

ls -lZR /config/usb_gadget > "${log_dir}"/configfs.old.log

# Do a query to force the configfs chown immediately.
"${mod_dir}"/msd-tool."$(getprop ro.product.cpu.abi)" \
    client get-functions

ls -lZR /config/usb_gadget > "${log_dir}"/configfs.new.log

ps -efZ > "${log_dir}"/ps.log

/system/bin/dmesg > "${log_dir}"/dmesg.log

cp /proc/self/mountinfo "${log_dir}"/mountinfo.log

/system/bin/dmesg -w | grep avc: > "${log_dir}"/audit.log &

logcat -s msd-tool > "${log_dir}"/msd-tool.log &

wait
